import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 12))
ax.set_xlim(0, 12)
ax.set_ylim(0, 12)
ax.set_aspect('equal')
ax.axis('off')

# Define positions and sizes for floors, elevators, and passengers
floor_positions = [0, 2.5, 5, 7.5, 10]
floor_height = 2
floor_width = 10
elevator_width = 0.6
elevator_height = 0.6
passenger_width = 0.4
passenger_height = 0.4

# Define colors
floor_color = "lightgrey"
fast_elevator_color = "blue"
slow_elevator_color = "green"
passenger_color = "yellow"
text_color = "black"

# Draw floors
for i, y in enumerate(floor_positions):
    ax.add_patch(patches.Rectangle((1, y), floor_width, floor_height, color=floor_color))
    ax.text(0.5, y + floor_height / 2, f'Floor {i}', va='center', ha='center', color=text_color, fontsize=10)

# Draw passengers
passengers = {
    'p2': (1.2, floor_positions[0] + 0.5),
    'p3': (1.8, floor_positions[0] + 0.5),
    'p0': (1.2, floor_positions[1] + 0.5),
    'p5': (1.8, floor_positions[1] + 0.5),
    'p1': (1.2, floor_positions[3] + 0.5),
    'p4': (1.8, floor_positions[3] + 0.5)
}

for p_id, (x, y) in passengers.items():
    ax.add_patch(patches.Rectangle((x, y), passenger_width, passenger_height, color=passenger_color))
    ax.text(x + passenger_width / 2, y + passenger_height / 2, p_id, va='center', ha='center', color=text_color, fontsize=8)

# Draw fast elevators
fast_elevators = {
    'fast0': (9, floor_positions[0] + 0.7),
    'fast1': (9, floor_positions[0] + 0.1)
}

for e_id, (x, y) in fast_elevators.items():
    ax.add_patch(patches.Rectangle((x, y), elevator_width, elevator_height, color=fast_elevator_color))
    ax.text(x + elevator_width / 2, y + elevator_height / 2, f'{e_id}\n0/2', va='center', ha='center', color=text_color, fontsize=8)

# Draw slow elevators
slow_elevators = {
    'slow0-0': (8, floor_positions[0] + 0.7),
    'slow1-0': (8, floor_positions[2] + 0.7)
}

for e_id, (x, y) in slow_elevators.items():
    ax.add_patch(patches.Rectangle((x, y), elevator_width, elevator_height, color=slow_elevator_color))
    ax.text(x + elevator_width / 2, y + elevator_height / 2, f'{e_id}\n0/1', va='center', ha='center', color=text_color, fontsize=8)

# Create legend
legend_elements = [
    patches.Patch(facecolor=fast_elevator_color, edgecolor='black', label='Fast Elevator'),
    patches.Patch(facecolor=slow_elevator_color, edgecolor='black', label='Slow Elevator'),
    patches.Patch(facecolor=passenger_color, edgecolor='black', label='Passenger')
]

ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.1, 1))

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_19.png', bbox_inches='tight')
plt.show()